# MainWindow.py
from ui import MainWindowUI as UI
from PyQt5.QtWidgets import QFileDialog,QMainWindow
from PyQt5.QtGui import QPixmap, QImage
import cv2
from PyQt5.QtCore import QTimer


class MainWindow(QMainWindow,UI):
    def __init__(self):
        super(MainWindow, self).__init__()
        self.setupUi(self)

        self.btn_video.clicked.connect(self.load_video)
        self.btn_stop_video.clicked.connect(self.stop_video)   
        self.btn_select.clicked.connect(self.select)
        self.btn_begin.clicked.connect(self.begin_track)
        
        self.track_flag=False

        self.timer = QTimer()#设置定时器，用来显示视频
        self.timer.timeout.connect(self.updateFrame)#定时器定时执行的函数 

    
    def display_image(self,img):
        if len(img.shape)==3:#彩色图像
            height, width, channel = img.shape
            bytes_per_line = channel * width
            q_img = QImage(img.data, width, height, bytes_per_line, QImage.Format_BGR888)
        else:               # 灰度图像或二值图像
            height, width= img.shape
            bytes_per_line = width
            q_img = QImage(img.data, width, height, bytes_per_line, QImage.Format_Grayscale8)            

        self.label.setPixmap(QPixmap.fromImage(q_img))

    def load_video(self):
        options = QFileDialog.Options()
        fileName, _ = QFileDialog.getOpenFileName(self, "Open Video File", "", "Video Files (*.mp4 *.avi *.mov);;All Files (*)", options=options)
        if fileName:
            self.cap = cv2.VideoCapture(fileName)
            if not self.cap.isOpened():
                print("Error: Could not open video.")
                return
            ret, frame = self.cap.read()
            if not ret:
                print("无法读取视频帧")
                return
            # 显示第一帧并让用户选择ROI
            self.frame=frame
            self.display_image(frame)
            
    def stop_video(self):
        # 获取当前按钮的文本
        current_text = self.btn_stop_video.text()
        
        # 根据当前文本，切换为“播放”或“停止”
        if current_text == '停止视频':
            self.btn_stop_video.setText('播放视频')
            self.timer.stop()
           
        else:
            self.btn_stop_video.setText('停止视频')
            self.timer.start(20)

    def select(self):

        self.timer.stop()
        self.btn_stop_video.setText('播放视频')
        ret, frame=self.cap.read()   
        if not ret:
            print("无法读取视频帧")
            return

        self.bbox = cv2.selectROI("Frame", frame, fromCenter=False, showCrosshair=True)
        cv2.destroyWindow("Frame")
        # 初始化KCF跟踪器
        self.tracker = cv2.TrackerKCF_create()
        self.tracker.init(frame, self.bbox)
       
        self.track_flag=True
        self.btn_begin.setText('停止跟踪')
        self.btn_stop_video.setText('停止视频')
        self.timer.start(20)        
        
        
    def begin_track(self):
     
        # 根据跟踪标志，切换为“开始”或“停止”
        if self.track_flag:
            self.btn_begin.setText('开始跟踪')
            self.track_flag=False
        else:
            self.btn_begin.setText('停止跟踪')
            self.track_flag=True      
        
        
    def track(self,frame):
        
        sucsess,bbox = self.tracker.update(frame)
        
        if sucsess:
            p1 = (int(bbox[0]), int(bbox[1]))
            p2 = (int(bbox[0] + bbox[2]), int(bbox[1] + bbox[3]))
            cv2.rectangle(frame, p1, p2, (255, 0, 0), 2, 1)
        else:
            cv2.putText(frame, "Fail to track", (100, 20),cv2.FONT_HERSHEY_SIMPLEX, 0.75, (0, 0, 255), 2)
        
        return frame

            
    def updateFrame(self):
            
        ret, frame = self.cap.read()
        
        if not ret:
            print("Error: Could not read frame from camera.")
            self.timer.stop()
            self.cap.release()
            return
            
        if self.track_flag:
            frame=self.track(frame)

        self.display_image(frame)#显示结果   
            

