#ui.py

from PyQt5.QtWidgets import QPushButton, QVBoxLayout, QHBoxLayout, QWidget, QLabel
from PyQt5.QtCore import Qt


class MainWindowUI(object):
   def setupUi(self, MainWindow):
       
        MainWindow.setObjectName("MainWindow")
        MainWindow.resize(400, 300)
        self.centralwidget = QWidget(MainWindow)
        
        self.setWindowTitle('运动物体跟踪系统')
        self.setGeometry(100, 100, 800, 600)
        
        self.main_layout=QVBoxLayout()
        
        self.layout1 = QHBoxLayout()
        self.label = QLabel(self)
        self.label.setAlignment(Qt.AlignCenter)
        self.layout1.addWidget(self.label)
         
        self.layout2 = QHBoxLayout()
        
        self.btn_video = QPushButton('打开视频', self)
        self.layout2.addWidget(self.btn_video)
        
        self.btn_stop_video = QPushButton('播放视频', self)
        self.layout2.addWidget(self.btn_stop_video)
        
        self.btn_select = QPushButton('选择跟踪物体', self)
        self.layout2.addWidget(self.btn_select)
        
        self.btn_begin = QPushButton('开始跟踪', self)
        self.layout2.addWidget(self.btn_begin)
        

        self.widget1 = QWidget()
        self.widget1.setLayout(self.layout1)
        
        self.widget2 = QWidget()
        self.widget2.setLayout(self.layout2)

        self.main_layout.addWidget(self.widget1)
        self.main_layout.addWidget(self.widget2)

        self.container = QWidget()
        self.container.setLayout(self.main_layout)
        self.setCentralWidget(self.container)
        
        self.btn_select_multi = QPushButton('选择多跟踪物体', self)
        self.layout2.addWidget(self.btn_select_multi)
        
        self.btn_begin_multi = QPushButton('开始多目标跟踪', self)
        self.layout2.addWidget(self.btn_begin_multi)


        
    
