import cv2

# 支持的跟踪器类型
TRACKERS = {
    "KCF": cv2.legacy.TrackerKCF_create,
    "CSRT": cv2.legacy.TrackerCSRT_create,
    "MOSSE": cv2.legacy.TrackerMOSSE_create,
    "MIL": cv2.legacy.TrackerMIL_create,
    "TLD": cv2.legacy.TrackerTLD_create,
    "MedianFlow": cv2.legacy.TrackerMedianFlow_create
}
# 选择跟踪器类型
tracker_name = "CSRT"
tracker = TRACKERS[tracker_name]()
# 初始化视频捕获
video_capture = cv2.VideoCapture("walker.mp4")
if not video_capture.isOpened():
    print("无法打开视频文件")
    exit()
# 读取第一帧
ret, frame = video_capture.read()
if not ret:
    print("无法读取视频帧")
    exit()
# 选择ROI
roi = cv2.selectROI("Select Target", frame, True, False)
tracker.init(frame, roi)
# 循环处理视频帧
while True:
    ret, frame = video_capture.read()
    if not ret:
        break
    # 更新跟踪器
    success, bbox = tracker.update(frame)
    if success:
        x, y, w, h = [int(v) for v in bbox] # 获取目标位置
        cv2.rectangle(frame, (x, y), (x + w, y + h), (0, 255, 0), 2) # 绘制目标框
    else:
        cv2.putText(frame, "Tracking Failed", (20, 50),
                    cv2.FONT_HERSHEY_SIMPLEX, 1, (0, 0, 255), 2)
    # 显示结果
    cv2.imshow("Tracking", frame)
    if cv2.waitKey(30) & 0xFF == ord('q'): # 按下q键退出循环
        break
video_capture.release() # 释放资源
cv2.destroyAllWindows() # 关闭显示视频的窗口