import cv2

video = cv2.VideoCapture("walker.mp4") # 打开视频文件
ret, frame = video.read() # 读取视频的第一帧
if not ret: # 如果读取视频文件失败，则退出循环
    print("无法读取视频")
    exit()
roi = cv2.selectROI("Select ROI", frame, True, False) # 选择ROI
x, y, w, h = roi # 提取ROI区域的坐标和宽度高度
tracker = cv2.TrackerKCF_create() # 创建KCF追踪器并初始化
tracker.init(frame, roi) # 初始化追踪器
# 循环处理视频帧
while True:
    ret, frame = video.read()
    if not ret:
        break
    # 更新追踪器
    success, roi = tracker.update(frame)
    if success:
        # 绘制追踪结果
        x, y, w, h = map(int, roi)
        cv2.rectangle(frame, (x, y), (x + w, y + h), (0, 255, 0), 2)
    # 显示结果
    cv2.imshow("Tracking", frame)
    if cv2.waitKey(30) & 0xFF == ord('q'): # 按下q键退出循环
        break
video.release() # 释放资源
cv2.destroyAllWindows() # 关闭显示视频的窗口