import cv2

image = cv2.imread("panda.png") # 读取图像
roi = cv2.selectROI("Select ROI", image, True, False) # 弹出窗口供用户选择ROI
cv2.destroyAllWindows() # 关闭选取 ROI 区域的窗口
# 提取ROI区域
if roi != (0, 0, 0, 0):  # 如果用户选择了有效的ROI区域
    x, y, w, h = roi # 提取ROI区域的坐标和宽度高度
    img_roi = image[y:y + h, x:x + w] # 裁剪图像
    cv2.imshow("ROI", img_roi) # 显示裁剪结果
    cv2.imwrite("roi.png", img_roi) # 保存裁剪结果
    cv2.waitKey(0) # 等待用户按键
    cv2.destroyAllWindows() # 关闭显示裁剪结果的窗口
else: # 如果用户未选择有效的ROI区域
    print("未选择有效的 ROI 区域。")