# MainWindow.py
from ui import MainWindowUI as UI
from PyQt5.QtWidgets import QFileDialog,QMainWindow
from PyQt5.QtGui import QPixmap, QImage
from PyQt5.QtCore import Qt,QTimer
import cv2



class MainWindow(QMainWindow,UI):
    def __init__(self):
        super(MainWindow, self).__init__()
        self.setupUi(self)

        self.btn_load.clicked.connect(self.load_image)
        self.btn_detect.clicked.connect(self.faceDetection)
        self.btn_video.clicked.connect(self.load_video)

        self.timer = QTimer()#设置定时器，用来显示视频
        self.timer.timeout.connect(self.updateFrame)#定时器定时执行的函数 
        
    
    def load_image(self):
        options = QFileDialog.Options()
        fileName, _ = QFileDialog.getOpenFileName(self, "QFileDialog.getOpenFileName()", "", "Image Files (*.png *.jpg *.jpeg)", options=options)
        if fileName:
            self.image = cv2.imread(fileName)
            self.display_image(self.image)
    
    def display_image(self,img):
        if len(img.shape)==3:#彩色图像
            height, width, channel = img.shape
            bytes_per_line = channel * width
            q_img = QImage(img.data, width, height, bytes_per_line, QImage.Format_BGR888)
        else:               # 灰度图像或二值图像
            height, width= img.shape
            bytes_per_line = width
            q_img = QImage(img.data, width, height, bytes_per_line, QImage.Format_Grayscale8)            

        self.label.setPixmap(QPixmap.fromImage(q_img))


    def detect_image(self,img):
        # 加载预训练的Haar特征分类器
        face_cascade = cv2.CascadeClassifier(r'D:\Anconda3\Install\envs\CV\Lib\site-packages\cv2\data\haarcascade_frontalface_default.xml')
        # 转换为灰度图像，因为Haar特征分类器要求灰度图像
        gray = cv2.cvtColor(img, cv2.COLOR_BGR2GRAY)
        # 检测图像中的人脸
        faces = face_cascade.detectMultiScale(gray, scaleFactor=1.1, minNeighbors=5)
        return faces

    def faceDetection(self):
        img=self.image.copy()
        faces=self.detect_image(img)         
        # 计数检测到的人脸数
        num_faces = len(faces)
        
        #在图像上显示人脸数量
        text = "Detected {} faces. "
        cv2.putText(img, text.format(num_faces), (20, 40), cv2.FONT_HERSHEY_SIMPLEX, 1.0, (0, 0, 255), 2)
         
        # 在每个人脸周围绘制矩形框
        for (x, y, w, h) in faces:
            cv2.rectangle(img, (x, y), (x+w, y+h), (0, 0, 255), 2)
            
        self.display_image(img)
        
    def load_video(self):
        options = QFileDialog.Options()
        fileName, _ = QFileDialog.getOpenFileName(self, "Open Video File", "", "Video Files (*.mp4 *.avi *.mov);;All Files (*)", options=options)
        if fileName:
            self.cap = cv2.VideoCapture(fileName)
            if not self.cap.isOpened():
                print("Error: Could not open video.")
                return

        self.timer.start(20)  # 每20毫秒更新一次帧
            
    def updateFrame(self):
            
            ret, frame = self.cap.read()
            
            if not ret:
                print("Error: Could not read frame from camera.")
                self.timer.stop()
                self.cap.release()
                return

            faces=self.detect_image(frame)         
            # 计数检测到的人脸数
            num_faces = len(faces)
            
            text = "Detected {} faces. "
            cv2.putText(frame, text.format(num_faces), (20, 40), cv2.FONT_HERSHEY_SIMPLEX, 1.0, (0, 0, 255), 2)
             
            # 在每个人脸周围绘制矩形框
            for (x, y, w, h) in faces:
                cv2.rectangle(frame, (x, y), (x+w, y+h), (0, 0, 255), 2)
            
            self.display_image(frame)

            
    def keyPressEvent(self, event):
            if event.key() == Qt.Key_Q:
                self.timer.stop()
                self.cap.release()