import cv2
video = cv2.VideoCapture("test.mp4") # 打开视频文件
pos_msec = video.get(cv2.CAP_PROP_POS_MSEC) # 获取当前播放位置（以毫秒为单位）
pos_frames = video.get(cv2.CAP_PROP_POS_FRAMES) # 获取当前帧索引
pos_avi_ratio = video.get(cv2.CAP_PROP_POS_AVI_RATIO) # 获取相对播放位置
fps = video.get(cv2.CAP_PROP_FPS) # 获取视频文件的帧速率
frame_count = video.get(cv2.CAP_PROP_FRAME_COUNT) # 获取视频文件的帧数
frame_width = int(video.get(cv2.CAP_PROP_FRAME_WIDTH)) # 获取视频文件的帧宽度
frame_height = int(video.get(cv2.CAP_PROP_FRAME_HEIGHT)) # 获取视频文件的帧高度
fourcc = int(video.get(cv2.CAP_PROP_FOURCC)) # 获取视频文件的编码格式
format = video.get(cv2.CAP_PROP_FORMAT) # 获取视频文件的格式
mode = video.get(cv2.CAP_PROP_MODE) # 获取视频文件的捕获模式
# 输出获取到的属性值
print(f"当前播放位置（毫秒）: {pos_msec} ms")
print(f"当前帧索引: {pos_frames}")
print(f"相对播放位置: {pos_avi_ratio}")
print(f"帧速率: {fps} fps")
print(f"总帧数: {frame_count}")
print(f"帧宽度: {frame_width} 像素")
print(f"帧高度: {frame_height} 像素")
print(f"编码格式: {fourcc}")
print(f"视频格式: {format}")
print(f"捕获模式: {mode}")
video.release()