import cv2
video = cv2.VideoCapture("test.mp4")  # 打开视频文件
cv2.namedWindow("Video", cv2.WINDOW_NORMAL)  # 创建窗口
cv2.resizeWindow("Video", 640, 480)  # 设置窗口大小
is_paused = False  # 初始化暂停状态为False
while video.isOpened():  # 视频文件被打开后
    ret, frame = video.read()  # 读取视频文件
    if not ret:  # 如果读取视频文件失败，则退出循环
        break
    if not is_paused:  # 如果不是暂停状态，则显示当前帧
        cv2.imshow("Video", frame)
    key = cv2.waitKey(25)  # 等待25毫秒，获取按键输入
    if key == ord(' '):  # 如果按下空格键，则切换暂停状态
        is_paused = not is_paused
    elif key == 27:  # 如果按下Esc键，则退出循环
        break
video.release()  # 释放视频文件
cv2.destroyAllWindows()