import cv2
video = cv2.VideoCapture("test.mp4")  # 打开视频文件
# 设置“Video”窗口的宽为640，高为480
cv2.namedWindow("Video", cv2.WINDOW_NORMAL)
cv2.resizeWindow("Video", 640, 480)
while video.isOpened():  # 视频文件被打开后
    ret, frame = video.read()  # 读取视频文件
    if not ret:  # 如果读取视频文件失败，则退出循环
        break
    cv2.imshow("Video", frame)  # 显示当前读取到的视频帧
    key = cv2.waitKey(25)  # 等待用户按键，等待时间为 25 毫秒
    if key == 27:  # 如果按下了Esc键（键码为 27），退出循环，结束视频播放
        break
video.release()  # 释放视频文件资源，关闭视频流
cv2.destroyAllWindows()  # 销毁显示视频文件的窗口