import cv2
image = cv2.imread("peoples.jpg")  # 读取图像名
gray_image = cv2.cvtColor(image, cv2.COLOR_BGR2GRAY)  # 转换为灰度图像
# 加载人脸检测级联分类器
face_cascade = cv2.CascadeClassifier("cascades/haarcascade_frontalface_default.xml")
# 加载微笑检测级联分类器
smile_cascade = cv2.CascadeClassifier("cascades/haarcascade_smile.xml")
# 检测人脸
faces = face_cascade.detectMultiScale(gray_image, scaleFactor=1.1, minNeighbors=5)
# 在检测到的人脸区域检测微笑
for (x, y, w, h) in faces:
    cv2.rectangle(image, (x, y), (x + w, y + h), (255, 0, 0), 2)
    roi_gray = gray_image[y:y + h, x:x + w]
    roi_color = image[y:y + h, x:x + w]
    # 检测微笑
    smiles = smile_cascade.detectMultiScale(roi_gray, scaleFactor=1.1, minNeighbors=22)
    # 在检测到的微笑区域绘制绿色矩形边框
    for (sx, sy, sw, sh) in smiles:
        cv2.rectangle(roi_color, (sx, sy), (sx + sw, sy + sh), (0, 255, 0), 2)
        cv2.putText(image, 'Smile', (x + sx, y + sy - 10), cv2.FONT_HERSHEY_SIMPLEX, 0.5, (0, 255, 0), 2)
cv2.imshow("Smile Detection", image)  # 显示结果图像
cv2.waitKey(0)  # 等待用户按键并关闭窗口
cv2.destroyAllWindows()