import cv2
img = cv2.imread("peoples.jpg")  # 读取图像
# 加载识别眼睛的级联分类器
eyeCascade = cv2.CascadeClassifier("cascades/haarcascade_eye.xml")
# 识别图像中的所有眼睛，1.05为图像缩放比例因子，可根据实际情况调整
eyes = eyeCascade.detectMultiScale(img, 1.05)
# 遍历所有眼睛的区
for (x, y, w, h) in eyes:
    # 在图像中眼睛的位置绘制方框
    cv2.rectangle(img, (x, y), (x + w, y + h), (0, 0, 255), 2)
cv2.imshow("img", img)  # 显示最终处理的效果
cv2.waitKey()  # 按下任何键盘按键后
cv2.destroyAllWindows()  # 释放所有窗体