import cv2
import numpy as np
# 创建空白画布（500x700像素，白色背景）
canvas = np.ones((500, 700, 3), dtype=np.uint8) * 255
# 绘制车身（蓝色矩形）
car_body = cv2.rectangle(
    img=canvas,
    pt1=(100, 200),  # 左上角坐标
    pt2=(600, 400),  # 右下角坐标
    color=(255, 0, 0),  # BGR颜色（蓝色）
    thickness=-1  # 填充
)
# 绘制车顶（梯形，通过多边形绘制）
roof_points = np.array([
    [150, 200],   # 左上
    [550, 200],   # 右上
    [500, 100],   # 顶点右
    [200, 100]    # 顶点左
], np.int32)
cv2.fillPoly(canvas, [roof_points], color=(255, 0, 0))  # 填充蓝色
# 绘制车窗（浅蓝色矩形）
cv2.rectangle(
    img=canvas,
    pt1=(250, 150),
    pt2=(450, 200),
    color=(255, 200, 100),  # 浅蓝色
    thickness=-1
)
# 绘制车轮（黑色圆形）
wheel1_center = (200, 400)
wheel2_center = (500, 400)
cv2.circle(canvas, wheel1_center, 50, (0, 0, 0), -1)  # 左轮
cv2.circle(canvas, wheel2_center, 50, (0, 0, 0), -1)  # 右轮
# 绘制轮毂（银色同心圆）
cv2.circle(canvas, wheel1_center, 30, (192, 192, 192), -1)
cv2.circle(canvas, wheel2_center, 30, (192, 192, 192), -1)
# 绘制车灯（黄色圆形）
cv2.circle(canvas, (600, 300), 20, (0, 255, 255), -1)  # 右车灯
cv2.circle(canvas, (100, 300), 20, (0, 255, 255), -1)  # 左车灯
# 添加文字标签
cv2.putText(canvas, "OpenCV Car", (250, 450),
           cv2.FONT_HERSHEY_SIMPLEX, 1, (0, 0, 0), 2)
# 显示结果
cv2.imshow("Simple Car Drawing", canvas)
cv2.waitKey(0)
cv2.destroyAllWindows()