import cv2
video = cv2.VideoCapture("test.mp4")
x, y, w, h = 100, 100, 300, 200  # 设置裁剪区域
while video.isOpened():
    ret, frame = video.read() # 读取视频文件
    if not ret:
        break
    cropped_frame = frame[y:y+h, x:x+w] # 裁剪帧
    cv2.imshow("Cropped Video", cropped_frame) # 显示裁剪后的帧
    if cv2.waitKey(25) & 0xFF == ord('q'): # 按 q 键退出循环
        break
video.release() # 释放资源
cv2.destroyAllWindows()