import cv2
video_capture = cv2.VideoCapture("test.mp4")  # 打开视频文件
if not video_capture.isOpened():  # 检查视频是否成功打开
    print("无法打开视频文件")
else:
    # 获取视频文件的帧速率和帧大小
    fps = video_capture.get(cv2.CAP_PROP_FPS)
    frame_width = int(video_capture.get(cv2.CAP_PROP_FRAME_WIDTH))
    frame_height = int(video_capture.get(cv2.CAP_PROP_FRAME_HEIGHT))
    size = (frame_width, frame_height)
    # 设置要保存的中间几秒的起始时间和持续时间（例如从第5秒开始，持续3秒）
    start_time = 5
    duration = 3
    # 计算起始帧和结束帧
    start_frame = int(start_time * fps)
    end_frame = int((start_time + duration) * fps)
    # 获取总帧数
    total_frames = int(video_capture.get(cv2.CAP_PROP_FRAME_COUNT))
    # 检查起始帧和结束帧是否有效
    if start_frame < 0 or end_frame > total_frames:
        print("指定的时间范围超出视频范围")
        video_capture.release()
        exit()
    # 定义编码格式并创建VideoWriter对象
    fourcc = cv2.VideoWriter_fourcc(*'XVID')
    video_writer = cv2.VideoWriter('middle_seconds.avi', fourcc, fps, size)
    # 跳转到起始帧
    video_capture.set(cv2.CAP_PROP_POS_FRAMES, start_frame)
    # 读取并保存视频帧
    current_frame = start_frame # 当前帧计数器
    while current_frame <= end_frame: # 循环读取视频帧
        ret, frame = video_capture.read()
        if not ret:
            break
        video_writer.write(frame) # 将读取到的帧写入VideoWriter对象
        current_frame += 1 # 当前帧计数器加一
    video_capture.release()  # 释放资源
    video_writer.release()
    print(f"视频文件的中间{duration}秒已保存为 middle_seconds.avi")