import cv2
video = cv2.VideoCapture("test.mp4") # 打开视频文件
# 检查视频文件是否成功打开
if not video.isOpened():
    print("无法打开视频文件")
else:
    fps = video.get(cv2.CAP_PROP_FPS) # 获取视频文件的帧速率
    # 获取视频文件的帧大小
    frame_width = int(video.get(cv2.CAP_PROP_FRAME_WIDTH))
    frame_height = int(video.get(cv2.CAP_PROP_FRAME_HEIGHT))
    size = (frame_width, frame_height)
    fourcc = cv2.VideoWriter_fourcc(*'XVID') # 确定视频被保存后的编码格式
    output = cv2.VideoWriter("five_Seconds.avi", fourcc, fps, size) # 创建VideoWriter类对象
    frame_Num = int(5 * fps)  # 视频文件的前10秒视频含有的帧数
    # 视频文件被打开后且视频文件的前5秒视频含有的帧数大于0
    while video.isOpened() and frame_Num > 0:
        ret, frame = video.read() # 读取视频文件
        if ret: # 读取到视频文件后
            output.write(frame) # 在VideoWriter类对象中写入读取到的帧
        frame_Num -= 1 # 视频文件的前5秒视频含有的帧数减少一帧
    # 控制台输出提示信息
    print("视频文件的前5s视频已保存为five_seconds.avi")
    video.release() # 关闭视频文件
    output.release() # 释放VideoWriter类对象