import cv2
video = cv2.VideoCapture("test.mp4") # 打开视频文件
if not video.isOpened(): # 视频文件打开失败
    print("无法打开视频文件")
else:
    fps = video.get(cv2.CAP_PROP_FPS) # 获取视频文件的帧速率
    # 获取视频文件的帧大小
    frame_width = int(video.get(cv2.CAP_PROP_FRAME_WIDTH))
    frame_height = int(video.get(cv2.CAP_PROP_FRAME_HEIGHT))
    size = (frame_width, frame_height)
    fourcc = cv2.VideoWriter_fourcc(*'XVID') # 确定视频被保存后的编码格式
    output = cv2.VideoWriter("test_copy.avi", fourcc, fps, size) # 创建VideoWriter类对象
    while video.isOpened(): # 视频文件被打开后
        ret, frame = video.read() # 读取视频文件
        if not ret: # 读取失败
            break
        output.write(frame) # 在VideoWriter类对象中写入读取到的帧
    print("视频文件已保存为test_copy.avi") # 控制台输出提示信息
    video.release() # 关闭视频文件
    output.release() # 释放VideoWriter类对象