import cv2
video = cv2.VideoCapture("test.mp4")  # 打开视频文件
fps = video.get(cv2.CAP_PROP_FPS)  # 获取视频文件的帧速率
total_frames = int(video.get(cv2.CAP_PROP_FRAME_COUNT))  # 获取视频文件的总帧数
# 创建窗口并调整大小
cv2.namedWindow("Video Player", cv2.WINDOW_NORMAL)
cv2.resizeWindow("Video Player", 640, 480)
current_frame = 0  # 初始化当前帧数
while video.isOpened():  # 循环读取视频文件
    ret, frame = video.read()  # 读取视频文件
    if not ret:  # 如果读取视频文件失败，则退出循环
        break
    current_frame += 1  # 更新当前帧数
    current_time = current_frame / fps   # 计算当前播放时间（秒）
    # 在帧上绘制文本
    text = f"frame {current_frame}/{total_frames}, time: {current_time:.2f}s"
    cv2.putText(frame, text, (10, 30), cv2.FONT_HERSHEY_SIMPLEX, 0.7, (0, 255, 0), 2)
    cv2.imshow("Video Player", frame)   # 显示帧
    key = cv2.waitKey(25)  # 等待按键事件
    if key == ord('q'):  # 按 q 键退出
        break
video.release()  # 释放资源
cv2.destroyAllWindows()