#ui.py

from PyQt5.QtWidgets import QPushButton, QVBoxLayout, QHBoxLayout, QWidget, QLabel
from PyQt5.QtCore import Qt


class MainWindowUI(object):
   def setupUi(self, MainWindow):
       
        MainWindow.setObjectName("MainWindow")
        MainWindow.resize(400, 300)
        self.centralwidget = QWidget(MainWindow)
        
        self.setWindowTitle('车牌识别系统')
        self.setGeometry(100, 100, 800, 600)
        
        self.main_layout=QHBoxLayout()
        
        self.layout1 = QVBoxLayout()
        self.label = QLabel(self)
        self.label.setAlignment(Qt.AlignCenter)
        self.layout1.addWidget(self.label)
        
        self.btn_load = QPushButton('打开图片', self)
        self.layout1.addWidget(self.btn_load)
        
        self.btn_detect = QPushButton('检测车牌', self)
        self.layout1.addWidget(self.btn_detect)
        
   
        self.layout2 = QVBoxLayout()
        self.label2 = QLabel(self)
        self.label2.setAlignment(Qt.AlignCenter)
        self.layout2.addWidget(self.label2)
        
        self.label3 = QLabel(self)
        self.label3.setAlignment(Qt.AlignCenter)
        self.layout2.addWidget(self.label3)
        
        self.btn_plate = QPushButton('获取车牌', self)
        self.layout2.addWidget(self.btn_plate)
        
        self.btn_seg = QPushButton('分割字符', self)
        self.layout2.addWidget(self.btn_seg)
        
        self.btn_reg = QPushButton('识别车牌', self)
        self.layout2.addWidget(self.btn_reg)
   
        self.widget1 = QWidget()
        self.widget1.setLayout(self.layout1)
        
        self.widget2 = QWidget()
        self.widget2.setLayout(self.layout2)

        self.main_layout.addWidget(self.widget1)
        self.main_layout.addWidget(self.widget2)

        self.container = QWidget()
        self.container.setLayout(self.main_layout)
        self.setCentralWidget(self.container)

        
    
