import cv2

image = cv2.imread("lightning.png") # 读取图像
image1 = image.copy() # 复制原图像
imgGray = cv2.cvtColor(image, cv2.COLOR_BGR2GRAY) # 转换为灰度图像
imgCanny = cv2.Canny(imgGray, 70, 200) # 边缘检测
# 查找轮廓
contours, hierarchy = cv2.findContours(imgCanny, cv2.RETR_EXTERNAL, cv2.CHAIN_APPROX_NONE)
# 计算第一种逼近精度，为“0.01×轮廓周长”
epsilon1 = 0.01 * cv2.arcLength(contours[0], True)
# 获取图像轮廓的近似多边形，使用第一种逼近精度
approxCurve1 = cv2.approxPolyDP(contours[0], epsilon1, True)
# 绘制近似多边形
image = cv2.drawContours(image, [approxCurve1], -1, (0, 255, 0), 3)
# 显示绘制近似多边形后的图像
cv2.imshow('Polygon1', image)
# 计算第二种逼近精度，为“0.05×轮廓周长”
epsilon2 = 0.05 * cv2.arcLength(contours[0], True)
# 获取图像轮廓的近似多边形，使用第二种逼近精度
approxCurve2 = cv2.approxPolyDP(contours[0], epsilon2, True)
# 绘制近似多边形
image1 = cv2.drawContours(image1, [approxCurve2], -1, (0, 255, 0), 3)
cv2.imshow('Polygon2', image1) # 显示绘制近似多边形后的图像
cv2.waitKey() # 窗口等待，按任意键继续
cv2.destroyAllWindows() # 释放所有窗口