import cv2

image = cv2.imread("lightning.png") # 读取图像
gray = cv2.cvtColor(image, cv2.COLOR_BGR2GRAY) # 转换为灰度图像
# 二值化处理
_, binary = cv2.threshold(gray, 127, 255, cv2.THRESH_BINARY)
# 查找轮廓
contours, _ = cv2.findContours(binary, cv2.RETR_LIST, cv2.CHAIN_APPROX_SIMPLE)
# 获取第一个轮廓的最小外接圆的圆心和半径
center, radius = cv2.minEnclosingCircle(contours[0])
x = int(round(center[0])) # 圆心横坐标转换为整数
y = int(round(center[1])) # 圆心纵坐标转换为整数
cv2.circle(image, (x, y), int(radius), (0, 255, 0), 2) # 绘制圆形
cv2.imshow("Min Enclosing Circles", image)  # 显示绘制结果
cv2.waitKey()  # 等待用户按下任何键盘按键
cv2.destroyAllWindows()  # 释放所有窗体