import cv2
import numpy as np

image = cv2.imread('lightning.png') # 读取图像
gray = cv2.cvtColor(image, cv2.COLOR_BGR2GRAY)  # 转换为灰度图像
_, binary = cv2.threshold(gray, 127, 255, cv2.THRESH_BINARY) # 二值化
contours, _ = cv2.findContours(binary, cv2.RETR_LIST, cv2.CHAIN_APPROX_SIMPLE)# 查找轮廓
# 遍历每个轮廓
for contour in contours:
    x, y, w, h = cv2.boundingRect(contour)  # 计算外接矩形
    cv2.rectangle(image, (x, y), (x + w, y + h), (0, 255, 0), 2) # 绘制外接矩形
    rect = cv2.minAreaRect(contour) # 计算最小外接矩形的中心点、宽、高和旋转角度
    box = cv2.boxPoints(rect) # 计算矩形的四个顶点
    box = np.intp(box) # 转换为整数类型
    # 绘制最小外接矩形
    cv2.drawContours(image, [box], 0, (0, 0, 255), 2)
cv2.imshow('Bounding Rectangles', image)  # 显示结果
cv2.waitKey(0)
cv2.destroyAllWindows()