import cv2

image=cv2.imread('shapes.png',cv2.COLOR_BGR2GRAY) # 读取原图像
# 使用高斯滤波进行降噪，(5, 5) 是卷积核大小，0 是标准差
blurred_image = cv2.GaussianBlur(image, (5, 5), 0)
# 进行 Canny 边缘检测，50 和 150 分别是低阈值和高阈值
edges = cv2.Canny(blurred_image, 50, 150)
# 查找轮廓，cv2.RETR_EXTERNAL 表示只检测外轮廓，cv2.CHAIN_APPROX_SIMPLE 表示只保留端点
contours, hierarchy = cv2.findContours(edges, cv2.RETR_EXTERNAL, cv2.CHAIN_APPROX_SIMPLE)
# 遍历所有轮廓
for i, contour in enumerate(contours):
    # 计算轮廓的周长，True 表示轮廓是闭合的
    length = cv2.arcLength(contour, True)
    # 计算轮廓的面积
    area = cv2.contourArea(contour)
    # 格式化输出轮廓的周长和面积
    print(f"轮廓 {i} 的周长: {length:.2f}")
    print(f"轮廓 {i} 的面积: {area:.2f}")