import cv2

image = cv2.imread("shapes.png")  # 读取原图
gray = cv2.cvtColor(image, cv2.COLOR_BGR2GRAY)  # 彩色图像转为单通道灰度图像
t, binary = cv2.threshold(gray, 127, 255, cv2.THRESH_BINARY)  # 灰度图像转为二值图像
# 检测图像中出现的所有轮廓，记录轮廓的每一个点
contours, hierarchy = cv2.findContours(binary, cv2.RETR_LIST, cv2.CHAIN_APPROX_NONE)
# 检测外轮廓
# contours, hierarchy = cv2.findContours(binary, cv2.RETR_EXTERNAL, cv2.CHAIN_APPROX_NONE)
# 绘制轮廓，宽度为3，颜色为青色
cv2.drawContours(image, contours, -1, (255, 255, 0), 3)
cv2.imshow("Binary Image", binary)  # 显示二值图像
cv2.imshow("Contours Image", image)  # 显示绘制结果
cv2.waitKey()  # 按下任何键盘按键后
cv2.destroyAllWindows()  # 释放所有窗体