import cv2
import numpy as np

image = cv2.imread("image.png")  # 读取原图
kernel = np.ones((5, 5), np.uint8)  # 创建 5x5 的结构元素作为核
dilated_img = cv2.dilate(image, kernel)  # 进行膨胀操作
eroded_img = cv2.erode(dilated_img, kernel)  # 对膨胀后的图像进行腐蚀操作
cv2.imshow("Original Image", image) # 显示原图
cv2.imshow("Dilated Image", dilated_img) # 显示腐蚀后的图像
cv2.imshow("Closing Image", eroded_img) # 显示闭运算处理后的图像
cv2.waitKey(0)  # 等待按键事件
cv2.destroyAllWindows()  # 关闭所有窗口