import cv2
import numpy as np

image = cv2.imread("image.png")  # 读取原图
kernel = np.ones((5, 5), np.uint8)  # 创建 5x5 的结构元素作为核
eroded_img = cv2.erode(image, kernel)  # 进行腐蚀操作
dilated_img = cv2.dilate(eroded_img, kernel)  # 对腐蚀后的图像进行膨胀操作
cv2.imshow("Original Image", image) # 显示原图
cv2.imshow("Eroded Image", eroded_img) # 显示腐蚀后的图像
cv2.imshow("Opening Image", dilated_img) # 显示开运算处理后的图像
cv2.waitKey(0) # 等待按键事件
cv2.destroyAllWindows() # 关闭所有窗口