import cv2
import numpy as np

image = cv2.imread("daminghu.jpg")
# 定义3x3的核
kernel_3x3 = np.ones((3, 3), np.uint8)
# 使用3x3核进行膨胀操作，迭代1次
dilated_once = cv2.dilate(image, kernel_3x3, iterations=1)
# 使用3x3核进行膨胀操作，迭代2次
dilated_twice = cv2.dilate(image, kernel_3x3, iterations=2)
# 显示原始图像和膨胀后的图像
cv2.imshow("Original Image", image)
cv2.imshow("Dilated with 3x3 Kernel (1 iteration)", dilated_once)
cv2.imshow("Dilated with 3x3 Kernel (2 iterations)", dilated_twice)
cv2.waitKey(0)  # 等待用户按键
cv2.destroyAllWindows()  # 关闭所有窗口