import cv2

image = cv2.imread("lightning.png")  # 读取图像
gray_image = cv2.cvtColor(image, cv2.COLOR_BGR2GRAY) # 转换为灰度图像
# 二值化处理
_, binary_image = cv2.threshold(gray_image, 127, 255, cv2.THRESH_BINARY)
# 查找轮廓
contours, _ = cv2.findContours(binary_image, cv2.RETR_LIST, cv2.CHAIN_APPROX_SIMPLE)
# 拟合直线
rows, cols = binary_image.shape # 获取图像的行数和列数
# 使用最小二乘法拟合直线
[vx, vy, x, y] = cv2.fitLine(contours[0], cv2.DIST_L2, 0, 0.01, 0.01)
lefty = int((-x * vy / vx) + y) # 计算直线的左端点
righty = int(((cols - x) * vy / vx) + y) # 计算直线的右端点
cv2.line(image, (cols - 1, righty), (0, lefty), (0, 255, 0), 2) # 在原始图像上绘制直线
cv2.imshow("Result", image) # 显示结果图像
cv2.waitKey(0) # 等待按键输入
cv2.destroyAllWindows() # 关闭所有窗口