import cv2

image = cv2.imread("lightning.png")  # 读取图像
gray_image = cv2.cvtColor(image, cv2.COLOR_BGR2GRAY)  # 转换为灰度图
# 二值化处理
_, binary_image = cv2.threshold(gray_image, 127, 255, cv2.THRESH_BINARY)
# 查找轮廓
contours, _ = cv2.findContours(binary_image, cv2.RETR_LIST, cv2.CHAIN_APPROX_SIMPLE)
ellipse = cv2.fitEllipse(contours[0])  # 拟合椭圆
cv2.ellipse(image, ellipse, (0, 255, 0), 3)  # 绘制椭圆
cv2.imshow("Result", image)  # 显示结果
cv2.waitKey(0)  # 等待用户按键并关闭窗口
cv2.destroyAllWindows()