import cv2
import numpy as np

image = cv2.imread("circle3.png")  # 读取原图
kernel = np.ones((5, 5), np.uint8)  # 创建 5x5 的作为核
# 进行黑帽运算
tophat_image = cv2.morphologyEx(image, cv2.MORPH_BLACKHAT, kernel)
# 进行闭运算
dilated_img = cv2.dilate(image, kernel)  # 进行膨胀操作
eroded_img = cv2.erode(dilated_img, kernel)  # 对膨胀后的图像进行腐蚀操作
# 显示图像
cv2.imshow("Original Image", image) # 显示原图
cv2.imshow("Closing Image", eroded_img) # 显示闭运算处理后的图像
cv2.imshow("Blackhat Operation Result", tophat_image) # 显示黑帽运算结果
cv2.waitKey(0)  # 等待用户按键
cv2.destroyAllWindows()  # 释放所有窗口