import cv2
import numpy as np

image = cv2.imread("circle2.png")  # 读取原图
kernel = np.ones((7, 7), np.uint8)  # 创建 7x7 的作为核
# 进行顶帽运算
tophat_image = cv2.morphologyEx(image, cv2.MORPH_TOPHAT, kernel)
# 进行开运算
eroded_img = cv2.erode(image, kernel)  # 进行腐蚀操作
dilated_img = cv2.dilate(eroded_img, kernel)  # 对腐蚀后的图像进行膨胀操作
# 显示图像
cv2.imshow("Original Image", image) # 显示原图
cv2.imshow("Opening Image", dilated_img) # 显示开运算处理后的图像
cv2.imshow("Tophat Operation Result", tophat_image) # 显示顶帽运算结果
cv2.waitKey(0)  # 等待用户按键
cv2.destroyAllWindows()  # 释放所有窗口