import cv2
import numpy as np

image = cv2.imread("circle.png")  # 读取原图
kernel = np.ones((5, 5), np.uint8)  # 创建 5x5 的结构元素作为核
gradient_image = cv2.morphologyEx(image, cv2.MORPH_GRADIENT, kernel)  # 进行梯度运算
cv2.imshow("Original Image", image)  # 显示原始图像
cv2.imshow("Gradient Operation Result", gradient_image)  # 显示梯度运算结果
cv2.waitKey(0)  # 等待用户按键
cv2.destroyAllWindows()  # 释放所有窗口