import cv2

image = cv2.imread("lightning.png") # 读取图像
gray_image = cv2.cvtColor(image, cv2.COLOR_BGR2GRAY) # 转换为灰度图像
# 二值化处理
_, binary_image = cv2.threshold(gray_image, 127, 255, cv2.THRESH_BINARY)
# 查找轮廓
contours, _ = cv2.findContours(binary_image, cv2.RETR_EXTERNAL, cv2.CHAIN_APPROX_SIMPLE)
hull = cv2.convexHull(contours[0]) # 计算凸包
cv2.drawContours(image, [hull], -1, (0, 255, 0), 2)
cv2.imshow("Convex Hull", image) # 显示结果
cv2.waitKey(0) # 按下任何键后关闭窗口
cv2.destroyAllWindows() # 关闭所有窗口