import cv2
import numpy as np

# 读取图像
img = cv2.imread('cactus.png')
# 使用 np.ones() 创建 3x3 矩形核
kernel3 = np.ones((3, 3), np.uint8)
# 使用 cv2.getStructuringElement() 创建 5x5 矩形核
kernel5 = cv2.getStructuringElement(cv2.MORPH_RECT, (5, 5))
# 对图像进行腐蚀操作
eroded3 = cv2.erode(img, kernel3, iterations=1)
eroded5 = cv2.erode(img, kernel5, iterations=1)
# 显示原图和腐蚀后的图像
cv2.imshow('Original', img)
cv2.imshow('Eroded with 3x3 Rect Kernel', eroded3)
cv2.imshow('Eroded with 5x5 RECT Kernel', eroded5)
cv2.waitKey(0)
cv2.destroyAllWindows()