# ui.py
# 从PyQt5.QtWidgets模块中导入所需的类，用于创建按钮、布局和窗口部件
from PyQt5.QtWidgets import QPushButton, QVBoxLayout, QHBoxLayout, QWidget, QLabel
# 从PyQt5.QtCore模块中导入Qt类，用于设置对齐方式等
from PyQt5.QtCore import Qt


# 定义MainWindowUI类，用于设置主窗口的用户界面
class MainWindowUI(object):
    # 定义setupUi方法，用于设置主窗口的界面布局
    def setupUi(self, MainWindow):
        # 设置主窗口的对象名称
        MainWindow.setObjectName("MainWindow")
        # 设置主窗口的初始大小
        MainWindow.resize(400, 300)
        # 创建一个中心部件
        self.centralwidget = QWidget(MainWindow)

        # 设置窗口标题
        self.setWindowTitle('二维码检测及识别系统')
        # 设置窗口的位置和大小
        self.setGeometry(100, 100, 800, 600)

        # 创建一个垂直布局
        self.main_layout = QVBoxLayout()

        # 创建一个垂直布局用于放置图像标签和结果标签
        self.layout1 = QVBoxLayout()
        # 创建一个标签用于显示图像
        self.label = QLabel(self)
        # 设置标签的对齐方式为居中
        self.label.setAlignment(Qt.AlignCenter)
        # 将标签添加到布局1中
        self.layout1.addWidget(self.label)

        # 创建一个标签用于显示二维码解码结果
        self.label2 = QLabel(self)
        # 设置标签的对齐方式为居中
        self.label2.setAlignment(Qt.AlignCenter)
        # 将标签添加到布局1中
        self.layout1.addWidget(self.label2)

        # 创建一个水平布局用于放置按钮
        self.layout2 = QHBoxLayout()

        # 创建一个“打开图片”按钮
        self.btn_load = QPushButton('打开图片', self)
        # 将按钮添加到布局2中
        self.layout2.addWidget(self.btn_load)

        # 创建一个“检测二维码”按钮
        self.btn_detect = QPushButton('检测二维码', self)
        # 将按钮添加到布局2中
        self.layout2.addWidget(self.btn_detect)

        # 创建一个“识别二维码”按钮
        self.btn_decode = QPushButton('识别二维码', self)
        # 将按钮添加到布局2中
        self.layout2.addWidget(self.btn_decode)

        # 创建一个部件并设置其布局为布局1
        self.widget1 = QWidget()
        self.widget1.setLayout(self.layout1)

        # 创建一个部件并设置其布局为布局2
        self.widget2 = QWidget()
        self.widget2.setLayout(self.layout2)

        # 将部件1和部件2添加到主布局中
        self.main_layout.addWidget(self.widget1)
        self.main_layout.addWidget(self.widget2)

        # 创建一个容器部件并设置其布局为主布局
        self.container = QWidget()
        self.container.setLayout(self.main_layout)
        # 将容器部件设置为中心部件
        self.setCentralWidget(self.container)

        # 创建一个“打开相机”按钮
        self.btn_cam = QPushButton('打开相机', self)
        # 将按钮添加到布局2中
        self.layout2.addWidget(self.btn_cam)

        # 创建一个“拍照检测”按钮
        self.btn_camQR = QPushButton('拍照检测', self)
        # 将按钮添加到布局2中
        self.layout2.addWidget(self.btn_camQR)