# main.py
# 导入sys模块，用于处理命令行参数
import sys
# 导入MainWindow模块，其中包含MainWindow类
import MainWindow
# 从PyQt5.QtWidgets模块中导入QApplication类，用于创建应用程序对象
from PyQt5.QtWidgets import QApplication


# 定义main函数，作为程序的入口点
def main():
    # 创建一个QApplication对象，传入命令行参数
    app = QApplication(sys.argv)
    # 创建一个MainWindow对象
    window = MainWindow.MainWindow()
    # 显示主窗口
    window.show()
    # 启动应用程序的事件循环，并在退出时返回退出代码
    sys.exit(app.exec_())


# 如果当前脚本是作为主程序运行
if __name__ == '__main__':
    # 调用main函数
    main()