# MainWindow.py
from ui import MainWindowUI as UI
from PyQt5.QtWidgets import QFileDialog,QMainWindow
from PyQt5.QtGui import QPixmap, QImage
import cv2
import numpy as np
from PyQt5.QtCore import Qt,QTimer


class MainWindow(QMainWindow,UI):
    def __init__(self):
        super(MainWindow, self).__init__()
        self.setupUi(self)


        self.btn_load.clicked.connect(self.load_image)
        self.btn_detect.clicked.connect(self.QRDetection)
        self.btn_decode.clicked.connect(self.QRdecode)
        self.btn_cam.clicked.connect(self.load_cam)
        self.btn_camQR.clicked.connect(self.camQR)
        
        self.timer = QTimer()#设置定时器，用来显示视频
        self.timer.timeout.connect(self.updateFrame)#定时器定时执行的函数 
        
    
    def load_image(self):
        options = QFileDialog.Options()
        fileName, _ = QFileDialog.getOpenFileName(self, "QFileDialog.getOpenFileName()", "", "Image Files (*.png *.jpg *.jpeg)", options=options)
        if fileName:
            self.image = cv2.imread(fileName)
            self.display_image(self.image)
    
    def display_image(self,img):
        if len(img.shape)==3:#彩色图像
            height, width, channel = img.shape
            bytes_per_line = channel * width
            q_img = QImage(img.data, width, height, bytes_per_line, QImage.Format_BGR888)
        else:               # 灰度图像或二值图像
            height, width= img.shape
            bytes_per_line = width
            q_img = QImage(img.data, width, height, bytes_per_line, QImage.Format_Grayscale8)            

        self.label.setPixmap(QPixmap.fromImage(q_img))
    def extend_img(self,image):
       # 有些二维码和边缘紧贴，无法识别出整个矩形，所以我们先对图片大小进行扩展
       expand_length = 10
       edge = expand_length // 2
       h, w = image.shape[:2]
       image_extend = np.zeros((image.shape[0] + expand_length, image.shape[1] + expand_length, 3), np.uint8)
       image_extend[:] = 255
       image_extend[edge:edge + h, edge:edge + w] = image

       return image_extend
        
    def pre_process(self,image):

       # 转灰度、二值化、找轮廓
       gray = cv2.cvtColor(image, cv2.COLOR_BGR2GRAY)
       # blur = cv2.GaussianBlur(gray, (5, 5), 0)
       _, thresh = cv2.threshold(gray, 127, 255, cv2.THRESH_BINARY)
       
       # cv2.imshow('bin',thresh)
       # cv2.waitKey(0)

       return thresh


    def getQR(self,image):

        image_extend=self.extend_img(image)
        thresh=self.pre_process(image_extend)
        
        contours, hir = cv2.findContours(thresh, cv2.RETR_TREE, cv2.CHAIN_APPROX_SIMPLE)

        # 三个“回”字特征轮廓存储
        parent_hierarchy_list = []
        parent_contours_list = []

        # 通过层级信息去查找三个“回”字特征区域
        for index, item in enumerate(hir[0][:-2]):  # 查找最外层（A）轮廓
            if item[2] != -1:
                parent_index = item[2] - 1
                if hir[0][index+1][3] == parent_index:  # 查找次一层（B）轮廓
                    child_first = hir[0][index+1][2] - 1
                    if hir[0][index+2][3] == child_first:   # 查找最里层（C）轮廓
                        # 计算A轮廓的周长和C轮廓周长的比值
                        error = cv2.arcLength(contours[parent_index], True) / cv2.arcLength(contours[parent_index + 2], True)
                        if 2 < error < 3:
                            parent_hierarchy_list.append(item)
                            parent_contours_list.append(contours[index])
                            # 绘制出三个“回”字特征区域的最外层轮廓
                            cv2.drawContours(image_extend, contours, index, (0, 255, 0), 3)

        # 将整个二维码区域绘制出来
        
        points_list = []
        for index, box in enumerate(parent_contours_list):
            x, y, w, h = cv2.boundingRect(box)
            # print(index,x, y, w, h)
            if index == 0:
                points_list.append((x, y+h))#左下角顶点
                # cv2.putText(image_extend,'0',(x,y+h),cv2.FONT_HERSHEY_COMPLEX, 1.0, (0, 0, 225), 1)
            if index == 1:
                points_list.append((x+w, y))#右上角顶点
                # cv2.putText(image_extend,'1',(x+w,y),cv2.FONT_HERSHEY_COMPLEX, 1.0, (0, 0, 225), 1)
            if index == 2:
                points_list.append((x, y))#左上角顶点
                # cv2.putText(image_extend,'2',(x,y),cv2.FONT_HERSHEY_COMPLEX, 1.0, (0, 0, 225), 1)
                
        points = np.array(points_list)

        #根据QR的3个顶点坐标计算第四个坐标    
        x4, y4 = (points[0][0] + points[1][0] - points[2][0], points[0][1] + points[1][1] - points[2][1])  # 示例，实际应用中可能需要更复杂的计算方法
     
        # 将四个点转换为数组形式以绘制正方形
        square_points = np.array([points[0], [x4, y4], points[1], points[2]])
        
        rect = cv2.minAreaRect(square_points)
        box = cv2.boxPoints(rect)
        box = np.intp(box)
        cv2.drawContours(image_extend, [box], 0, (0, 0,255), 2)
        
        QR_img=image_extend[square_points[3][1]:y4,points[2][0]:x4]

        return QR_img,image_extend
    
    def QRDetection(self):
        image=self.image.copy()
     
        self.QR_img,image_extend=self.getQR(image)

        self.display_image(image_extend)  # 更新显示识别后的图像
        
    def decode(self, img):
        # 将裁剪出的二维码图像转换为灰度图
        gray = cv2.cvtColor(img, cv2.COLOR_BGR2GRAY)
        
        # 创建QRCodeDetector对象
        detector = cv2.QRCodeDetector()
        # 检测并解码二维码
        data, bbox, rectifiedImage = detector.detectAndDecode(gray)
        
        if data:
            text = "二维码解码结果:{}"
            text=text.format(data)
        else:
            text="未检测到二维码"
        
        return text

    def QRdecode(self):
        
        text=self.decode(self.QR_img)

        self.label2.setText(text)
    
    
    def load_cam(self):
        self.cap = cv2.VideoCapture(0)
        if not self.cap.isOpened():
            print("Error: Could not open video.")
            return

        self.timer.start(20)  # 每20毫秒更新一次帧
        
    def camQR(self):

        image=self.frame
        self.timer.stop()
        self.cap.release()        

        self.QR_img,image_extend=self.getQR(image)

        self.display_image(image_extend)  # 更新显示识别后的图像
            
    def updateFrame(self):
            
        ret, frame = self.cap.read()
        
        if not ret:
            print("Error: Could not read frame from camera.")
            self.timer.stop()
            self.cap.release()
            return
        
        self.frame=frame        
        self.display_image(frame)

            
    def keyPressEvent(self, event):
            if event.key() == Qt.Key_Q:
                self.timer.stop()
                self.cap.release()