import cv2
import matplotlib.pyplot as plt

# 读取图像
original_image = cv2.imread("daminghu.jpg")
# 将 BGR 转换为 RGB,OpenCV默认采用的是BGR颜色空间；而 matplotlib默认使用的是RGB颜色空间。
original_image = cv2.cvtColor(original_image, cv2.COLOR_BGR2RGB)
ret1, binary = cv2.threshold(original_image, 127, 255, cv2.THRESH_BINARY)  # 二值阈值化
ret2, binary_inv = cv2.threshold(original_image, 127, 255, cv2.THRESH_BINARY_INV)  # 二值阈值化的反转
ret3, trunc = cv2.threshold(original_image, 127, 255, cv2.THRESH_TRUNC)  # 截断阈值化
ret4, tozero = cv2.threshold(original_image, 127, 255, cv2.THRESH_TOZERO)   # 归零阈值化
ret5, tozero_inv = cv2.threshold(original_image, 127, 255, cv2.THRESH_TOZERO_INV)  # 归零阈值化的反转
# 定义图像和对应的标题
titles = ['Original Image', 'BINARY', 'BINARY_INV', 'TRUNC', 'TOZERO', 'TOZERO_INV']
# 定义图像列表
images = [original_image, binary, binary_inv, trunc, tozero, tozero_inv]
# 创建一个更大的画布
fig = plt.figure(figsize=(10, 6))
for i in range(6):
    plt.subplot(2, 3, i+1), plt.imshow(images[i], "gray")  # 以两行三列方式显示6张图片
    plt.title(titles[i])  # 设置图片标题
    plt.xticks([]), plt.yticks([])  # 取消坐标轴的刻度
# 显示图片
plt.show()