import cv2
import numpy as np
# img = cv2.imread("black.png", 0)  # 将图像读成灰度图像

# 生成一个宽度为600，高度为200的渐变图像
width, height = 600, 200
image = np.zeros((height, width), dtype=np.uint8)
# 生成一个有黑到白，像素值从0到255的灰度渐变图像
for y in range(height):
    for x in range(width):
        image[y, x] = int(255 * (x / (width - 1)))
t1, dst1 = cv2.threshold(image, 127, 255, cv2.THRESH_BINARY)  # 二值化阈值处理
t2, dst2 = cv2.threshold(image, 200, 255, cv2.THRESH_BINARY)  # 调高阈值效果
t3, dst3 = cv2.threshold(image, 127, 160, cv2.THRESH_BINARY)  # 调低最大值效果
cv2.imshow('thresh:127 & maxval:255', dst1)  # 展示阈值为127时的效果
cv2.imshow('thresh:200 & maxval:255', dst2)  # 展示阈值为210时的效果
cv2.imshow('thresh:127 & maxval:160', dst3)  # 展示最大值为15时的效果
cv2.waitKey()  # 按下任何键盘按键后
cv2.destroyAllWindows()  # 释放所有窗体