import cv2

image = cv2.imread("stone.jpg") # 读取图片
image_gray = cv2.cvtColor(image, cv2.COLOR_BGR2GRAY) # 转换为灰度图像
t1, dst1 = cv2.threshold(image_gray, 127, 255, cv2.THRESH_BINARY) # 二值化阈值处理
# 实现Otsu方法的阈值处理
t2, dst2 = cv2.threshold(image_gray, 0, 255, cv2.THRESH_BINARY  + cv2.THRESH_OTSU)
# 获取文字内容
text = "best threshold: " + str(t2)
# 获取字体、字号、粗细等信息
font = cv2.FONT_HERSHEY_SIMPLEX
font_scale = 1
thickness = 2
# 计算文字的宽度和高度
(text_width, text_height), _ = cv2.getTextSize(text, font, font_scale, thickness)
# 定义文字绘制的位置
x = 0
y = 30
# 绘制黑色矩形作为文字背景
cv2.rectangle(dst2, (x, y - text_height), (x + text_width, y), 0, -1)
# 在图像上绘制最合适的阈值，使用白色（255）作为文字颜色
cv2.putText(dst2, text, (x, y), font, font_scale, 255, thickness)
cv2.imshow("Original", image)  # 显示原图
cv2.imshow("Gray", image_gray)  # 显示原始灰度图像
cv2.imshow("BINARY", dst1)  # 显示二值化阈值处理的图像
cv2.imshow("OTSU", dst2)  # 显示实现 Otsu 方法的阈值处理
cv2.waitKey()  # 按下任何键盘按键后
cv2.destroyAllWindows()  # 销毁所有窗口