import cv2

image = cv2.imread("daminghu.jpg")  #读取图像
gray_image = cv2.cvtColor(image, cv2.COLOR_BGR2GRAY) # 转换为灰度图像
# 应用自适应阈值处理（均值法）
adaptive_mean_result = cv2.adaptiveThreshold(
    gray_image, 255, cv2.ADAPTIVE_THRESH_MEAN_C, cv2.THRESH_BINARY, 5, 3
)
# 应用自适应阈值处理（高斯法）
adaptive_gaussian_result = cv2.adaptiveThreshold(
    gray_image, 255, cv2.ADAPTIVE_THRESH_GAUSSIAN_C, cv2.THRESH_BINARY, 5, 3
)
# 显示原始灰度图像
cv2.imshow("Original Grayscale Image", gray_image)
# 显示自适应阈值处理的结果
cv2.imshow("adaptive_mean_result", adaptive_mean_result)
cv2.imshow("adaptive_gaussian_result", adaptive_gaussian_result)
cv2.waitKey() # 按下任何键盘按键后
cv2.destroyAllWindows() # 销毁所有窗口