import cv2
import numpy as np
import matplotlib.pyplot as plt

# 生成一个宽度为600，高度为200的渐变图像
width, height = 600, 200
original_image = np.zeros((height, width), dtype=np.uint8)
# 生成一个有黑到白，像素值从0到255的灰度渐变图像
for y in range(height):
    for x in range(width):
        original_image[y, x] = int(255 * (x / (width - 1)))

ret1, binary = cv2.threshold(original_image, 127, 255, cv2.THRESH_BINARY)  # 二值阈值化
ret2, binary_inv = cv2.threshold(original_image, 127, 255, cv2.THRESH_BINARY_INV)  # 二值阈值化的反转
ret3, trunc = cv2.threshold(original_image, 127, 255, cv2.THRESH_TRUNC)  # 截断阈值化
ret4, tozero = cv2.threshold(original_image, 127, 255, cv2.THRESH_TOZERO)   # 归零阈值化
ret5, tozero_inv = cv2.threshold(original_image, 127, 255, cv2.THRESH_TOZERO_INV)  # 归零阈值化的反转
# 定义图像和对应的标题
titles = ['Original Image', 'BINARY', 'BINARY_INV', 'TRUNC', 'TOZERO', 'TOZERO_INV']
# 定义图像列表
images = [original_image, binary, binary_inv, trunc, tozero, tozero_inv]
# 创建一个更大的画布
fig = plt.figure(figsize=(10, 6))
for i in range(6):
    plt.subplot(2, 3, i+1), plt.imshow(images[i], "gray")  # 以两行三列方式显示6张图片
    plt.title(titles[i])  # 设置图片标题
    plt.xticks([]), plt.yticks([])  # 取消坐标轴的刻度
# 显示图片
plt.show()