import cv2

def decode(img):
    # 将裁剪出的二维码图像转换为灰度图
    gray = cv2.cvtColor(img, cv2.COLOR_BGR2GRAY)

    # 创建QRCodeDetector对象
    detector = cv2.QRCodeDetector()
    # 检测并解码二维码
    data, _, _ = detector.detectAndDecode(gray)
    return data

if __name__ == "__main__":
    # 在这里指定图像文件的路径，你可以根据实际情况修改
    image_path = "example_qr.png"

    # 读取图像文件
    img = cv2.imread(image_path)
    if img is None:
        print(f"无法读取图像文件: {image_path}")
    else:
        result = decode(img)
        print(result)