import qrcode

# 创建二维码对象
qr = qrcode.QRCode(
    version=2,
    error_correction=qrcode.constants.ERROR_CORRECT_Q,
    box_size=15,
    border=5
)

# 添加数据
qr.add_data("Hello opencv")

# 生成二维码矩阵
qr.make(fit=True)

# 创建二维码图像
img = qr.make_image(fill_color="black", back_color="white")

# 保存二维码图像
img.save("example_qr.png")