import cv2
import numpy as np

# 初始化全局变量
drawing = False  # drawing用于标记是否正在进行绘制操作，初始值为False表示未开始绘制
center = (0, 0)  # center用于存储绘制圆形的圆心坐标，初始值为(0, 0)
radius = 0  # radius用于存储绘制圆形的半径，初始值为0
# 鼠标事件回调函数，用于处理鼠标的各种操作事件
def draw_circle(event, x, y, flags, param):
    # 声明使用全局变量，这样在函数内部才能对这些全局变量进行修改
    global center, radius, drawing, mode
    # 当鼠标左键按下时
    if event == cv2.EVENT_LBUTTONDOWN:
        # 将drawing设置为True，表示开始进行绘制操作
        drawing = True
        # 记录当前鼠标点击位置作为圆心坐标
        center = (x, y)
        # 半径初始化为0
        radius = 0
    # 当鼠标移动时
    elif event == cv2.EVENT_MOUSEMOVE:
        # 只有当drawing为True，即正在进行绘制操作时才执行以下代码
        if drawing:
            # 计算当前鼠标位置到圆心的距离，并取整作为半径
            radius = int(np.sqrt((x - center[0]) ** 2 + (y - center[1]) ** 2))
    # 当鼠标左键松开时
    elif event == cv2.EVENT_LBUTTONUP:
        # 将drawing设置为False，表示绘制操作结束
        drawing = False
        # 在图像img上，以center为圆心，radius为半径绘制一个绿色（BGR格式：(0, 255, 0)）的实心圆（线宽为-1表示实心）
        cv2.circle(img, center, radius, (0, 255, 0), -1)
# 创建一个大小为512x512的白色背景图像，数据类型为np.uint8，通道数为3（表示彩色图像）
img = np.ones((512, 512, 3), np.uint8) * 255
# 创建一个名为'image'的窗口
cv2.namedWindow('image')
# 将鼠标事件回调函数draw_circle与'image'窗口绑定，这样在该窗口上的鼠标操作就会调用这个函数
cv2.setMouseCallback('image', draw_circle)
while True:
    # 在'image'窗口中显示图像img
    cv2.imshow('image', img)
    # 等待1毫秒获取键盘输入，如果按下的键的ASCII码为27（即Esc键），则退出循环
    if cv2.waitKey(1) & 0xFF == 27:
        break
cv2.destroyAllWindows()  # 关闭所有OpenCV窗口，释放资源