import cv2
import numpy as np

# 创建一个 500x500 的彩色画布，数据类型为 np.uint8
canvas = np.zeros((500, 500, 3), dtype=np.uint8)
# 定义五角星的顶点坐标，这里的坐标是预先设定好的，但可能不是标准的五角星坐标
# 每个坐标是一个二元组，分别表示 x 和 y 坐标
pts = np.array([[70, 190], [222, 190], [280, 61], [330, 190], [467, 190],
                [358, 260], [392, 380], [280, 308], [195, 260], [138, 380]])
# 将顶点坐标数组进行形状重塑，以符合 cv2.polylines 函数的输入要求
# reshape((-1, 1, 2)) 会将数组转换为一个形状为 (10, 1, 2) 的三维数组
# 其中 10 表示有 10 个顶点，每个顶点由一个包含 2 个元素（x 和 y 坐标）的一维数组表示
pts = pts.reshape((-1, 1, 2))
# 打印顶点坐标数组的形状，确认转换后的结果
print(pts.shape)  # 输出 (10, 1, 2)
canvas = cv2.polylines(canvas, [pts], True, (0, 255, 255), 5)  # 在画布上绘制多边形
cv2.imshow('Star Polylines', canvas)  # 示绘制好的图像
cv2.waitKey()  # 等待用户按下任意键，程序暂停在此处
cv2.destroyAllWindows()  # 关闭所有 OpenCV 打开的窗口