import cv2
import time
import numpy as np
import math

width, height = 400, 400  # 画布尺寸
center_x, center_y = width // 2, height // 2  # 风车中心位置
blade_length = 100  # 风车叶片长度
angle = 0  # 旋转角度
angle_increment = 5  # 角度增量
while True:
    # 创建白色背景画布
    canvas = np.ones((height, width, 3), dtype=np.uint8) * 255
    # 绘制风车叶片
    num_blades = 4
    for i in range(num_blades):
        blade_angle = math.radians(angle + i * (360 / num_blades))
        x1 = int(center_x + blade_length * math.cos(blade_angle))
        y1 = int(center_y + blade_length * math.sin(blade_angle))
        x2 = int(center_x + blade_length * 0.2 * math.cos(blade_angle + math.radians(90)))
        y2 = int(center_y + blade_length * 0.2 * math.sin(blade_angle + math.radians(90)))
        x3 = int(center_x + blade_length * 0.2 * math.cos(blade_angle - math.radians(90)))
        y3 = int(center_y + blade_length * 0.2 * math.sin(blade_angle - math.radians(90)))
        pts = np.array([[x1, y1], [x2, y2], [center_x, center_y], [x3, y3]], np.int32)
        pts = pts.reshape((-1, 1, 2))
        cv2.fillPoly(canvas, [pts], (0, 0, 255))
    # 绘制风车中心
    cv2.circle(canvas, (center_x, center_y), 10, (0, 255, 0), -1)
    # 显示画面
    cv2.imshow('Rotating Windmill', canvas)
    # 更新旋转角度
    angle += angle_increment
    if angle >= 360:
        angle = 0
    if cv2.waitKey(10) & 0xFF == ord('q'):
        break
    # 休眠一段时间，实现 60 帧每秒的动画效果
    time.sleep(1 / 60)
cv2.destroyAllWindows()