import cv2 as cv
import numpy as np

# 创建白色背景（模拟道路标牌材质）
canvas = np.ones((600, 600, 3), dtype=np.uint8) * 255
# 绘制禁止停车标志（红色边框+斜线）
# 外圆（红色边框，线宽8像素）
cv.circle(canvas, (300, 300), 200, (0, 0, 255), 8)
# 内圆（红色实心填充）
cv.circle(canvas, (300, 300), 180, (0, 0, 255), -1)
# 白色斜线（覆盖中心区域）
cv.line(canvas, (150, 150), (450, 450), (255, 255, 255), 20)
cv.imshow("Traffic Sign Simulation", canvas)  # 显示模拟的交通标志
cv.waitKey(0)
cv.destroyAllWindows()