import numpy as np
import cv2

# 创建一个 400x400 的彩色画布，数据类型为 np.uint8
canvas = np.zeros((400, 400, 3), np.uint8)
# 定义圆心坐标，这里选择画布的中心
center = (200, 200)
# 定义不同颜色的列表，用于绘制不同颜色的同心圆
colors = [
    (0, 0, 255),  # 红色
    (0, 255, 255),  # 黄色
    (0, 255, 0),  # 绿色
    (255, 255, 0),  # 青色
    (255, 0, 0)  # 蓝色
]
# 定义每个圆的半径，半径依次减小
radii = [150, 120, 90, 60, 30]
# 循环绘制同心圆
for i in range(len(colors)):
    # 使用 cv2.circle() 函数绘制实心圆
    canvas = cv2.circle(canvas, center, radii[i], colors[i], -1)
cv2.imshow("Target Board", canvas)  # 显示绘制好的图像
cv2.waitKey(0)  # 等待用户按下任意键
cv2.destroyAllWindows()  # 关闭所有 OpenCV 窗口