# import numpy as np  # 引入numpy模块
# import cv2 as cv  # 引入cv模块
#
# # 绘制一个300*300大小的画布，3代表有3个通道，unit8为图像存储格式
# canvas = np.ones((200, 300, 3), np.uint8) * 255
# # 在画布上，绘制一个圆心坐标为(50, 100)，半径为40，红色的圆环
# canvas = cv.circle(canvas, (50, 100), 40, (0, 0, 255), 3)
# # 在画布上，绘制一个圆心坐标为(150, 100)，半径为40，黄色的实心圆形
# canvas = cv.circle(canvas, (150, 100), 40, (0, 255, 255), -1)
# # 在画布上，绘制一个圆心坐标为(250, 100)，半径为40，蓝色的实心圆形
# canvas = cv.circle(canvas, (250, 100), 40, (255, 0, 0), -1)  # 第三个圆形
# cv.imshow('Clicles', canvas)  # 在屏幕展示绘制圆形的效果
# cv.waitKey()  # 图像不会自动关闭
# cv.destroyAllWindows()  # 释放所有窗口

import cv2
import numpy as np

drawing = False
center = (0, 0)
radius = 0

def mouse_callback(event, x, y, flags, param):
    global drawing, center, radius
    if event == cv2.EVENT_LBUTTONDOWN:
        drawing = True
        center = (x, y)
    elif event == cv2.EVENT_MOUSEMOVE and drawing:
        radius = int(((x - center[0])**2 + (y - center[1])**2)**0.5)
        canvas = np.ones((480, 640, 3), np.uint8) * 255
        cv2.circle(canvas, center, radius, (0, 0, 255), 2)
        cv2.imshow("Dynamic Circle", canvas)
    elif event == cv2.EVENT_LBUTTONUP:
        drawing = False

cv2.namedWindow("Dynamic Circle")
cv2.setMouseCallback("Dynamic Circle", mouse_callback)
cv2.waitKey(0)