import cv2

background = cv2.imread("baotuquna.png")  # 背景图像
logo = cv2.imread("logo.png")  # 前景图像
# 将前景图像缩放成指定大小
resized_logo = cv2.resize(logo, (100, 80))
cv2.imshow("Background Image", background)  # 显示原始背景图像
cv2.imshow("Foreground Image", logo)  # 显示前景图像
cv2.imshow("Resized Product", resized_logo)  # 显示缩放后图像
rows, cols, channels = resized_logo.shape  # 获取缩放后商品图像的尺寸
# 将缩放后的图像覆盖到背景图像的指定位置
background[20:20 + rows, 20:20 + cols, :] = resized_logo
# 显示覆盖后的背景图像
cv2.imshow("Background with Product", background)
cv2.waitKey(0)  # 等待用户按键并关闭窗口
cv2.destroyAllWindows()